/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.pipe;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DumpTube
extends AbstractFilterTubeImpl {
    private final String name;
    private final PrintStream out;
    private final XMLOutputFactory staxOut;
    private static boolean warnStaxUtils;

    public DumpTube(String string, PrintStream printStream, Tube tube) {
        super(tube);
        this.name = string;
        this.out = printStream;
        this.staxOut = XMLOutputFactory.newInstance();
    }

    protected DumpTube(DumpTube dumpTube, TubeCloner tubeCloner) {
        super(dumpTube, tubeCloner);
        this.name = dumpTube.name;
        this.out = dumpTube.out;
        this.staxOut = dumpTube.staxOut;
    }

    @Override
    public NextAction processRequest(Packet packet) {
        this.dump("request", packet);
        return super.processRequest(packet);
    }

    @Override
    public NextAction processResponse(Packet packet) {
        this.dump("response", packet);
        return super.processResponse(packet);
    }

    protected void dump(String string, Packet packet) {
        this.out.println("====[" + this.name + ":" + string + "]====");
        if (packet.getMessage() == null) {
            this.out.println("(none)");
        } else {
            try {
                XMLStreamWriter xMLStreamWriter = this.staxOut.createXMLStreamWriter(new PrintStream(this.out){

                    @Override
                    public void close() {
                    }
                });
                xMLStreamWriter = this.createIndenter(xMLStreamWriter);
                packet.getMessage().copy().writeTo(xMLStreamWriter);
                xMLStreamWriter.close();
            }
            catch (XMLStreamException xMLStreamException) {
                xMLStreamException.printStackTrace(this.out);
            }
        }
        this.out.println("============");
    }

    private XMLStreamWriter createIndenter(XMLStreamWriter xMLStreamWriter) {
        block2: {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("javanet.staxutils.IndentingXMLStreamWriter");
                Constructor<?> constructor = clazz.getConstructor(XMLStreamWriter.class);
                xMLStreamWriter = (XMLStreamWriter)constructor.newInstance(xMLStreamWriter);
            }
            catch (Exception exception) {
                if (warnStaxUtils) break block2;
                warnStaxUtils = true;
                this.out.println("WARNING: put stax-utils.jar to the classpath to indent the dump output");
            }
        }
        return xMLStreamWriter;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new DumpTube(this, tubeCloner);
    }
}

