/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import sun.awt.AWTAccessor;
import sun.awt.Win32GraphicsConfig;
import sun.awt.windows.WComponentPeer;
import sun.java2d.InvalidPipeException;
import sun.java2d.ScreenUpdateManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DGraphicsConfig;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DRenderQueue;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.windows.GDIWindowSurfaceData;
import sun.java2d.windows.WindowsFlags;
import sun.misc.ThreadGroupUtils;

public class D3DScreenUpdateManager
extends ScreenUpdateManager
implements Runnable {
    private static final int MIN_WIN_SIZE = 150;
    private volatile boolean done = false;
    private volatile Thread screenUpdater;
    private boolean needsUpdateNow;
    private Object runLock = new Object();
    private ArrayList<D3DSurfaceData.D3DWindowSurfaceData> d3dwSurfaces;
    private HashMap<D3DSurfaceData.D3DWindowSurfaceData, GDIWindowSurfaceData> gdiSurfaces;

    public D3DScreenUpdateManager() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadGroup threadGroup = ThreadGroupUtils.getRootThreadGroup();
                Thread thread = new Thread(threadGroup, new Runnable(){

                    @Override
                    public void run() {
                        D3DScreenUpdateManager.this.done = true;
                        D3DScreenUpdateManager.this.wakeUpUpdateThread();
                    }
                });
                thread.setContextClassLoader(null);
                try {
                    Runtime.getRuntime().addShutdownHook(thread);
                }
                catch (Exception exception) {
                    D3DScreenUpdateManager.this.done = true;
                }
                return null;
            }
        });
    }

    @Override
    public SurfaceData createScreenSurface(Win32GraphicsConfig win32GraphicsConfig, WComponentPeer wComponentPeer, int n, boolean bl) {
        if (this.done || !(win32GraphicsConfig instanceof D3DGraphicsConfig)) {
            return super.createScreenSurface(win32GraphicsConfig, wComponentPeer, n, bl);
        }
        SurfaceData surfaceData = null;
        if (D3DScreenUpdateManager.canUseD3DOnScreen(wComponentPeer, win32GraphicsConfig, n)) {
            try {
                surfaceData = D3DSurfaceData.createData(wComponentPeer);
            }
            catch (InvalidPipeException invalidPipeException) {
                surfaceData = null;
            }
        }
        if (surfaceData == null) {
            surfaceData = GDIWindowSurfaceData.createData(wComponentPeer);
        }
        if (bl) {
            this.repaintPeerTarget(wComponentPeer);
        }
        return surfaceData;
    }

    public static boolean canUseD3DOnScreen(WComponentPeer wComponentPeer, Win32GraphicsConfig win32GraphicsConfig, int n) {
        if (!(win32GraphicsConfig instanceof D3DGraphicsConfig)) {
            return false;
        }
        D3DGraphicsConfig d3DGraphicsConfig = (D3DGraphicsConfig)win32GraphicsConfig;
        D3DGraphicsDevice d3DGraphicsDevice = d3DGraphicsConfig.getD3DDevice();
        String string = wComponentPeer.getClass().getName();
        Rectangle rectangle = wComponentPeer.getBounds();
        Component component = (Component)wComponentPeer.getTarget();
        Window window = d3DGraphicsDevice.getFullScreenWindow();
        return !(!WindowsFlags.isD3DOnScreenEnabled() || !d3DGraphicsDevice.isD3DEnabledOnDevice() || !wComponentPeer.isAccelCapable() || rectangle.width <= 150 && rectangle.height <= 150 || n != 0 || window != null && (window != component || D3DScreenUpdateManager.hasHWChildren(component)) || !string.equals("sun.awt.windows.WCanvasPeer") && !string.equals("sun.awt.windows.WDialogPeer") && !string.equals("sun.awt.windows.WPanelPeer") && !string.equals("sun.awt.windows.WWindowPeer") && !string.equals("sun.awt.windows.WFramePeer") && !string.equals("sun.awt.windows.WEmbeddedFramePeer"));
    }

    @Override
    public Graphics2D createGraphics(SurfaceData surfaceData, WComponentPeer wComponentPeer, Color color, Color color2, Font font) {
        if (!this.done && surfaceData instanceof D3DSurfaceData.D3DWindowSurfaceData) {
            D3DSurfaceData.D3DWindowSurfaceData d3DWindowSurfaceData = (D3DSurfaceData.D3DWindowSurfaceData)surfaceData;
            if (!d3DWindowSurfaceData.isSurfaceLost() || this.validate(d3DWindowSurfaceData)) {
                this.trackScreenSurface(d3DWindowSurfaceData);
                return new SunGraphics2D(surfaceData, color, color2, font);
            }
            surfaceData = this.getGdiSurface(d3DWindowSurfaceData);
        }
        return super.createGraphics(surfaceData, wComponentPeer, color, color2, font);
    }

    private void repaintPeerTarget(WComponentPeer wComponentPeer) {
        Component component = (Component)wComponentPeer.getTarget();
        Rectangle rectangle = AWTAccessor.getComponentAccessor().getBounds(component);
        wComponentPeer.handlePaint(0, 0, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackScreenSurface(SurfaceData surfaceData) {
        if (!this.done && surfaceData instanceof D3DSurfaceData.D3DWindowSurfaceData) {
            D3DScreenUpdateManager d3DScreenUpdateManager = this;
            synchronized (d3DScreenUpdateManager) {
                D3DSurfaceData.D3DWindowSurfaceData d3DWindowSurfaceData;
                if (this.d3dwSurfaces == null) {
                    this.d3dwSurfaces = new ArrayList();
                }
                if (!this.d3dwSurfaces.contains(d3DWindowSurfaceData = (D3DSurfaceData.D3DWindowSurfaceData)surfaceData)) {
                    this.d3dwSurfaces.add(d3DWindowSurfaceData);
                }
            }
            this.startUpdateThread();
        }
    }

    @Override
    public synchronized void dropScreenSurface(SurfaceData surfaceData) {
        if (this.d3dwSurfaces != null && surfaceData instanceof D3DSurfaceData.D3DWindowSurfaceData) {
            D3DSurfaceData.D3DWindowSurfaceData d3DWindowSurfaceData = (D3DSurfaceData.D3DWindowSurfaceData)surfaceData;
            this.removeGdiSurface(d3DWindowSurfaceData);
            this.d3dwSurfaces.remove(d3DWindowSurfaceData);
        }
    }

    @Override
    public SurfaceData getReplacementScreenSurface(WComponentPeer wComponentPeer, SurfaceData surfaceData) {
        SurfaceData surfaceData2 = super.getReplacementScreenSurface(wComponentPeer, surfaceData);
        this.trackScreenSurface(surfaceData2);
        return surfaceData2;
    }

    private void removeGdiSurface(D3DSurfaceData.D3DWindowSurfaceData d3DWindowSurfaceData) {
        GDIWindowSurfaceData gDIWindowSurfaceData;
        if (this.gdiSurfaces != null && (gDIWindowSurfaceData = this.gdiSurfaces.get(d3DWindowSurfaceData)) != null) {
            gDIWindowSurfaceData.invalidate();
            this.gdiSurfaces.remove(d3DWindowSurfaceData);
        }
    }

    private synchronized void startUpdateThread() {
        if (this.screenUpdater == null) {
            this.screenUpdater = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    ThreadGroup threadGroup = ThreadGroupUtils.getRootThreadGroup();
                    Thread thread = new Thread(threadGroup, D3DScreenUpdateManager.this, "D3D Screen Updater");
                    thread.setPriority(7);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.screenUpdater.start();
        } else {
            this.wakeUpUpdateThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpUpdateThread() {
        Object object = this.runLock;
        synchronized (object) {
            this.runLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpdateNow() {
        Object object = this;
        synchronized (object) {
            if (this.done || this.screenUpdater == null || this.d3dwSurfaces == null || this.d3dwSurfaces.size() == 0) {
                return;
            }
        }
        object = this.runLock;
        synchronized (object) {
            this.needsUpdateNow = true;
            this.runLock.notifyAll();
            while (this.needsUpdateNow) {
                try {
                    this.runLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (!this.done) {
            long l;
            D3DSurfaceData.D3DWindowSurfaceData[] d3DWindowSurfaceDataArray = this.runLock;
            // MONITORENTER : this.runLock
            long l2 = l = this.d3dwSurfaces.size() > 0 ? 100L : 0L;
            if (!this.needsUpdateNow) {
                try {
                    this.runLock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : d3DWindowSurfaceDataArray
            d3DWindowSurfaceDataArray = new D3DSurfaceData.D3DWindowSurfaceData[]{};
            D3DScreenUpdateManager d3DScreenUpdateManager = this;
            // MONITORENTER : d3DScreenUpdateManager
            d3DWindowSurfaceDataArray = this.d3dwSurfaces.toArray(d3DWindowSurfaceDataArray);
            // MONITOREXIT : d3DScreenUpdateManager
            for (D3DSurfaceData.D3DWindowSurfaceData d3DWindowSurfaceData : d3DWindowSurfaceDataArray) {
                if (!d3DWindowSurfaceData.isValid() || !d3DWindowSurfaceData.isDirty() && !d3DWindowSurfaceData.isSurfaceLost()) continue;
                if (!d3DWindowSurfaceData.isSurfaceLost()) {
                    D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
                    d3DRenderQueue.lock();
                    try {
                        Rectangle rectangle = d3DWindowSurfaceData.getBounds();
                        D3DSurfaceData.swapBuffers(d3DWindowSurfaceData, 0, 0, rectangle.width, rectangle.height);
                        d3DWindowSurfaceData.markClean();
                        continue;
                    }
                    finally {
                        d3DRenderQueue.unlock();
                    }
                }
                if (this.validate(d3DWindowSurfaceData)) continue;
                d3DWindowSurfaceData.getPeer().replaceSurfaceDataLater();
            }
            Object object = this.runLock;
            // MONITORENTER : object
            this.needsUpdateNow = false;
            this.runLock.notifyAll();
            // MONITOREXIT : object
        }
    }

    private boolean validate(D3DSurfaceData.D3DWindowSurfaceData d3DWindowSurfaceData) {
        if (d3DWindowSurfaceData.isSurfaceLost()) {
            try {
                d3DWindowSurfaceData.restoreSurface();
                Color color = d3DWindowSurfaceData.getPeer().getBackgroundNoSync();
                SunGraphics2D sunGraphics2D = new SunGraphics2D(d3DWindowSurfaceData, color, color, null);
                sunGraphics2D.fillRect(0, 0, d3DWindowSurfaceData.getBounds().width, d3DWindowSurfaceData.getBounds().height);
                sunGraphics2D.dispose();
                d3DWindowSurfaceData.markClean();
                this.repaintPeerTarget(d3DWindowSurfaceData.getPeer());
            }
            catch (InvalidPipeException invalidPipeException) {
                return false;
            }
        }
        return true;
    }

    private synchronized SurfaceData getGdiSurface(D3DSurfaceData.D3DWindowSurfaceData d3DWindowSurfaceData) {
        GDIWindowSurfaceData gDIWindowSurfaceData;
        if (this.gdiSurfaces == null) {
            this.gdiSurfaces = new HashMap();
        }
        if ((gDIWindowSurfaceData = this.gdiSurfaces.get(d3DWindowSurfaceData)) == null) {
            gDIWindowSurfaceData = GDIWindowSurfaceData.createData(d3DWindowSurfaceData.getPeer());
            this.gdiSurfaces.put(d3DWindowSurfaceData, gDIWindowSurfaceData);
        }
        return gDIWindowSurfaceData;
    }

    private static boolean hasHWChildren(Component component) {
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                if (!(component2.getPeer() instanceof WComponentPeer) && !D3DScreenUpdateManager.hasHWChildren(component2)) continue;
                return true;
            }
        }
        return false;
    }
}

