/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.Block;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class IfStatement
extends AstNode {
    private AstNode condition;
    private AstNode thenPart;
    private int elsePosition = -1;
    private AstNode elsePart;
    private int lp = -1;
    private int rp = -1;

    public IfStatement() {
        this.type = 112;
    }

    public IfStatement(int n) {
        super(n);
        this.type = 112;
    }

    public IfStatement(int n, int n2) {
        super(n, n2);
        this.type = 112;
    }

    public AstNode getCondition() {
        return this.condition;
    }

    public void setCondition(AstNode astNode) {
        this.assertNotNull(astNode);
        this.condition = astNode;
        astNode.setParent(this);
    }

    public AstNode getThenPart() {
        return this.thenPart;
    }

    public void setThenPart(AstNode astNode) {
        this.assertNotNull(astNode);
        this.thenPart = astNode;
        astNode.setParent(this);
    }

    public AstNode getElsePart() {
        return this.elsePart;
    }

    public void setElsePart(AstNode astNode) {
        this.elsePart = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public int getElsePosition() {
        return this.elsePosition;
    }

    public void setElsePosition(int n) {
        this.elsePosition = n;
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    @Override
    public String toSource(int n) {
        String string = this.makeIndent(n);
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string);
        stringBuilder.append("if (");
        stringBuilder.append(this.condition.toSource(0));
        stringBuilder.append(") ");
        if (!(this.thenPart instanceof Block)) {
            stringBuilder.append("\n").append(this.makeIndent(n));
        }
        stringBuilder.append(this.thenPart.toSource(n).trim());
        if (this.elsePart instanceof IfStatement) {
            stringBuilder.append(" else ");
            stringBuilder.append(this.elsePart.toSource(n).trim());
        } else if (this.elsePart != null) {
            stringBuilder.append(" else ");
            stringBuilder.append(this.elsePart.toSource(n).trim());
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.condition.visit(nodeVisitor);
            this.thenPart.visit(nodeVisitor);
            if (this.elsePart != null) {
                this.elsePart.visit(nodeVisitor);
            }
        }
    }
}

